<?php

function spline($chart,$tags,$values,$columns,$x_axis){
$myConfig=array();
$myConfig['type']="line";

$myConfig['background-color']="#F4F4F4"  ;
$myConfig['legend']['background-color']="none";
$myConfig['legend']['border-width']=0;
$myConfig['legend']['shadow']=false;
$myConfig['legend']['layout']="float";
$myConfig['legend']['marker']['border-radius']=3;
$myConfig['legend']['marker']['border-width']=1;
$myConfig['legend']['item']['color']="%backgroundcolor";
$myConfig['legend']['visible']=true;	
$myConfig['legend']['toggleAction']="remove";
$myConfig['legend']['header']['text']="Click to Hide";


$myConfig['title']['text']="Spline ". count($values) . " Points ". $chart['title'];
$myConfig['title']['background-color']="none";
$myConfig['title']['font-size']=16;
$myConfig['title']['color']="#626262";

$myConfig['plotarea']['background-color']="#FFFFFF";
$myConfig['plotarea']['border-color']="#DFE1E3";
$myConfig['plotarea']['border-width']=1;
$myConfig['plotarea']['border-radius']=3;
$myConfig['plotarea']['margin']="dynamic";

$i=0;
//echo"<script> console.log('X axis tag is ".$chart['x_point']."');</script>";
foreach($x_axis as $dataset){
	$myConfig['scale-x']['labels'][]=$dataset[$chart['x_point']];
	$i++;
}



$myConfig['scale-x']['max-items']=10;
$myConfig['scale-x']['transform']['type']="date";
$myConfig['scale-x']['transform']['all']="%D, %d %M %Y %h:%i %A";
$myConfig['scale-x']['label']['text']="Date";
$myConfig['scale-x']['zooming']=1;
$myConfig['scale-y']['auto-fit']=true;

$myConfig['crosshair-x']['line-color']="#222222";
$myConfig['crosshair-x']['line-width']=1;
$myConfig['crosshair-x']['plot-label']['visible']=true;

if (count($values)<50){
	$myConfig['plot']['aspect']="spline";
	$myConfig['plot']['animation']['delay']=0;
	$myConfig['plot']['animation']['effect']=2;
	$myConfig['plot']['animation']['speed']="ANIMATION_FAST";
	$myConfig['plot']['animation']['method']=0;
	$myConfig['plot']['animation']['sequence']=1;
	
	$myConfig['plot']['tooltip']['text']="%v ";
	$myConfig['plot']['tooltip']['shadow']=false;
	$myConfig['plot']['tooltip']['border-radius']=3;
	$myConfig['plot']['tooltip']['visible']=true;
	//$myConfig['plot']['marker']['background-color']=$tags[$point]['color'];
	$myConfig['plot']['margin-right']="10%";
	$myConfig['plot']['border-width']=0;
	$myConfig['plot']['shadow']=0;
	
	} else {
	$myConfig['plot']['aspect']="spline";
	$myConfig['plot']['marker']['visible']=false;
	$myConfig['plot']['tooltip']['visible']=false;
	$myConfig['plot']['value-box']['visible']=false;
	$myConfig['preview']['type']="area";
	$myConfig['preview']['height']="15%";
	$myConfig['preview']['width']="100%";
	$myConfig['preview']['alpha']=0.5;
	$myConfig['plotarea']['margin-bottom']="25%";
	
	
	}






$series=array();

$i=0;
foreach($columns as $point){
//echo "<script> console.log('Processing Point ".$point."');</script>";	
	foreach($values as $dataset){
		$myConfig['series'][$i]['values'][]=$dataset[$point];
	}
	$myConfig['series'][$i]['text']=$tags[$point]['name'];
	$myConfig['series'][$i]['line-color']=$tags[$point]['color'];
	$myConfig['series'][$i]['tooltip']['text']=$tags[$point]['name']." %v ".$tags[$point]['unit']	;
	$myConfig['series'][$i]['decimals']=$tags[$point]['valueDecimal'];
	$myConfig['series'][$i]['marker']['background-color']=$tags[$point]['color'];
$i++;
}


return $myConfig;
}

	

?>