<?php
//============================================================+
// File name   : example_009.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 009 for TCPDF class
//               Test Image
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Test Image
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');
require('../db.php');
require('tcpdf.php');

if (isset($_GET['id']))
	{
	$in = $_GET["id"];

$data=explode(",",$in);

$testID=$data[1];

$pass = $data[0];


$mysqli = new mysqli($servername, $username, $password, $dbname);

if ($mysqli->connect_errno) 
	{
    	printf("Connect failed: %s\n", $mysqli->connect_error);
    	exit();
	}
$query="Select * from security where pass='".$pass."'";	

	if ($result = $mysqli->query($query)) 
		{
    		$sec = $result->fetch_assoc();
   		}
   		else
   		{
   		echo " Record Not Found ".$query." <br>";
   		exit();
   		}


$site =$sec['site'];
$table = $site . "_Tests_Data";


}
else
{
exit();
}

$query="Select * from $table where testid=$testID";
	if ($result = $mysqli->query($query)) 
		{
    		$testdata = $result->fetch_assoc();
    		$devid = $testdata['devid'];
		$devtype=$testdata['devtype'];
		$serial=$testdata['serialnumber'];
		$prodorder=$testdata['productionorder'];
		$tstamp=$testdata['TimeStamp'];
   		}
   		else
   		{
   		echo " Record Not Found ".$query." <br>";
   		}


$timestamp = strtotime($tstamp);
$time= date("m-d-Y", $timestamp);


$matID=explode("00",$devid);




$mysqli->close;

$conn = new mysqli($servername, $username, $password, $dbname2); 
if ($conn->connect_error) {
  trigger_error('Database connection failed: '  . $conn->connect_error, E_USER_ERROR);
}

	$sql= "Select * from pimvs where idnr=".$devid."";
	
	if ($result = $conn->query($sql))
	{ 
	$i=0;
	$row=array();
	$devData=array();
	//echo "Data in <br>";
	$interval=0;		
	while($row=mysqli_fetch_array($result,MYSQLI_ASSOC))
		{
		$devData[$interval][0]= $row['description'];
		$devData[$interval][1]=$row['value'];
		$interval+=1;  
		}
	$num=count($devData);
	}
	else
	{
	  // echo " Record Not Found ".$sql." <br>";
   	}





$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Burkert Fluid Controls');
$pdf->SetTitle(' ');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData( PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.'Device: '.$devtype.' ','Test ID#: '.$testID.'');

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('dejavusans', '', 10);

// add a page
$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);


$html='
<table>
	<tr>
		
		<td style="align:left"><b>Date:</b> '.$time.'</td>
		<td rowspan="5" align="right"><img src="https://www.burkert.com/var/harmony/storage/images/productthumbnail/8/6/9/2650121-8693-007-A-8692_thumb_productthumbnail.png" width="120" height="166" alt="8693 Control Valve"/></td>
		<td width="25%"></td>
		
		
	</tr>
	
	<tr>
		<td><b>Production Order:</b> '.$prodorder.'</td>
	</tr>
	<tr>
		<td><b>Device Type: </b>'.$devtype.'</td>
	</tr>
	<tr>
		<td><b>Device ID:</b> '.$devid.'</td>
	</tr>
	
	<tr>
		<td><b>Serial Number:</b>'.$serial.'</td>
	</tr>
	
	<tr>
		<td colspan="2">   </td>
	</tr>
	<tr>
		<td colspan="3"><img src="http://thecloudatburkert.com/script/ml_img.php?data='.$data[0].'_log,8693,'.$testID.',,1000", height="500"></td>
	 </tr>
</table>
<br>

';

$pdf->writeHTML($html, true, false, true, false, '');

$table='<table width="80%"><tr><td colspan=4><h2>Device Information </h2></td></tr>';


for ($I=0;$I<$interval;$I++){

$table.='




<tr>
<td style="font-weight:bold" width="35%">'.$devData[$I][0].'</td>

<td style="align:left" width="65%">'.$devData[$I][1].'</td>

</tr>';

}


$table.='</table>';

$pdf->writeHTML($table, true, false, true, false, '');

$pdf->Write(10, 'Search Burkert For Type '.$devtype.' Series Information', 'http://www.burkert.com/en/type/'.$devtype, false, 'C', true);
$pdf->Write(10, 'Search Burkert for part #'.$devid, 'http://www.burkert.com/en/sitesearch?search_term='.$devid, false, 'C', true);












// reset pointer to the last page
$pdf->lastPage();



// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Print a table

// add a page
//$pdf->AddPage();

// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output(''.$devtype.'_'.$serial.'_'.$time.'.pdf', 'D');


?>