<?php
/**
 * This file loads content from four different data tables depending on the required time range.
 * The stockquotes table containts 1.7 million data points. Since we are loading OHLC data and
 * MySQL has no concept of first and last in a data group, we have extracted groups by hours, days
 * and months into separate tables. If we were to load a line series with average data, we wouldn't
 * have to do this.
 * 
 * @param callback {String} The name of the JSONP callback to pad the JSON within
 * @param start {Integer} The starting point in JS time
 * @param end {Integer} The ending point in JS time
 */
// get the parameters

require('db.php');
if (isset($_GET['table']))
	{
	$in = $_GET["table"];
	$data_in=explode("/",$in);
	$table=$data_in[0];
	$command=$data_in[1];
	
	}

//header('Access-Control-Allow-Origin: *');


header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
//$batch_id=2;
//phpinfo(32);
//echo $_SERVER['PATH_INFO'];
if ($_SERVER["PATH_INFO"]=="/"){
	echo "200 ok";
	}
//echo "/* console.log('Data In = $in'); */ \r\n";



$conn = new mysqli($servername, $username, $password, $dbname); 
if ($conn->connect_error) {
  trigger_error('Database connection failed: '  . $conn->connect_error, E_USER_ERROR);
}

if ($command=="search"){
	$sql = "SHOW COLUMNS FROM ".$table;
	$result = $conn->query($sql);
	while($row = mysqli_fetch_array($result)){
	//echo $row['Field']."<br>";
	if(($row[Field]!=='TimeStamp') && ($row[Field]!=='epoch') && ($row[Field]!=="id")){
		$encode[]=$row[Field];
		}
	
	}
	
}
if ($command=="query"){
	if($_SERVER['REQUEST_METHOD']=='OPTION'){

	$sql = "SHOW COLUMNS FROM ultraclear_calgary_trend_Data";
	//echo $sql."<br>";
	$result = $conn->query($sql);
	//$encode[]=$result;
	while($row = mysqli_fetch_array($result)){
	//echo $row['Field']."<br>";
	$rows[]=$row[Field];	
	}
	$i=0;
	foreach($rows as $row){
	if(($row!=='TimeStamp') && ($row!=='epoch') && ($row!=="id")){
		$sql ="select epoch ,cast(".$row." as decimal) as ".$row." FROM ".$table." order by epoch desc limit 100";
		//echo $sql."<br>";
		$result = $conn->query($sql);
		$dataset[$i][target]=$row;	
		while($data=mysqli_fetch_array($result)){
			$dataset[$i][datapoints][]=array(($data[$row]*1),($data[epoch]*1000));
		}
		//echo json_encode($dataset[$i])."<br>";
		$i++;
	}
	}
	$encode=$dataset;
	//$sql = "select * FROM ultraclear_calgary_trend_Data limit 2";
	//$result = $conn->query($sql);
	//while($row = mysqli_fetch_array($result)){
	//$encode[][
	
	
	//}


	}
	//echo $_SERVER['REQUEST_METHOD'];
	if($_SERVER['REQUEST_METHOD']=='POST'){
		//echo"post<br>";
		$request_body = file_get_contents('php://input');
		//echo $request_body."\n";
		$data_Request = json_decode($request_body);
		$range=$data_Request->range;
		//print_r($data_Request);
		//echo  "from = ".$range->from." Converted =" .strtotime($range->from)."\n";
		//echo "to = ".$range->to." Converted =" .strtotime($range->to)."\n";
		//echo "Max Points =".$data_Request->maxDataPoints."\n";
		$targets=$data_Request->targets;
		$i=0;
		foreach($targets as $target_obj){
			//echo "Target = ".$target_obj->target."\n";
				
			$sql= "select epoch ,cast(" .$target_obj->target. " as decimal) as " .$target_obj->target. " FROM ".$table." where epoch > " .strtotime($range->from). " and epoch < " .strtotime($range->to). " order by epoch desc";
			//echo "SQL= ".$sql."\n";
			$result = $conn->query($sql);
			$row_cnt=mysqli_num_rows($result);
			//echo "rows  = ".$row_cnt."\n";
			$row_cnt =$row_cnt/250;
			$row_offset = Floor($row_cnt);
			if ($row_offset==0){$row_offset=1;}
			//echo "Row Offset = ".$row_offset."\n";
			$row_index=0;
			$index=0;
			$dataset[$i][target]=$target_obj->target;
			while ($row = $result->fetch_array(MYSQLI_ASSOC)) 
			{
			if ($row_index==0 || $row_index % $row_offset==0)
			{
				$dataset[$i][datapoints][]=array(($row[$target_obj->target]*1),($row[epoch]*1000)); 
				
			}
			 $row_index++;   	
    			}
			$encode=$dataset;

		$i++;
		}
		
	}
}


//echo '["upper_25","upper_50","upper_75","upper_90","upper_95"]';
echo json_encode($encode);   
mysqli_close($conn);
?>