<?php
//============================================================+
// File name   : example_009.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 009 for TCPDF class
//               Test Image
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Test Image
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');
require('../db.php');
require('tcpdf.php');

if (isset($_GET['id']))
	{
	$in = $_GET["id"];
	$data=explode(",",$in);	
	$id=$data[1];	
	$pass = $data[0];	
	$mysqli = new mysqli($servername, $username, $password, $dbname);	
	if ($mysqli->connect_errno) 
		{
	    	printf("Connect failed: %s\n", $mysqli->connect_error);
	    	exit();
		}
	$query="Select * from security where pass='".$pass."'";	
	
		if ($result = $mysqli->query($query)) 
			{
	    		$sec = $result->fetch_assoc();
	    		$site =$sec['site'];
			$table = $site . "_Tests_Data";
			$log_table=$site . "_log_Data";
	   		}
	   		else
	   		{
	   		echo " Record Not Found <br>".$query." <br>";
	   		exit();
	   		}
	}
else
{
exit();
}

$sql= "SELECT * FROM ".$log_table." where r1=".$id." ORDER BY epoch DESC Limit 1";
//echo "/* console.log('$sql'); */";
	if ($result = $mysqli->query($sql)) 
	{
	$log = $result->fetch_array(MYSQLI_ASSOC);
	$Cal_volume=$log['r24'];
	$Dev_volume=$log['r25'];
	}
	else
   	{
   	echo " Record Not Found <br>".$sql." <br>";
   	exit();
   	}
   	
$sql= "SELECT * FROM ".$table." where r1=".$id;
//echo "/* console.log('$sql'); */";
	if ($result = $mysqli->query($sql)) 
	{
	$row_cnt=mysqli_num_rows($result);
	$row_cnt =$row_cnt/1000;
	$row_offset = Floor($row_cnt);
	$arr=array();
	$encode=array();
	$columns=array();
	$columns = explode(",",$points);
	$point_count = count($columns);
	$row=array();
	$row = $result->fetch_array(MYSQLI_ASSOC);
	}
	else
   	{
   	echo " Record Not Found <br>".$sql." <br>";
   	exit();
   	}




$i=0;




$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Burkert Fluid Controls');
$pdf->SetTitle(' ');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData( PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.'Device: '.$row['r3'].' ','Test ID#: '.$row['r1'].'');

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('dejavusans', '', 10);

// add a page
$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);
$link1="http://thecloudatburkert.com/script/ml1.php?data=$data[0],10,$data[1],,1000";
$link2="http://thecloudatburkert.com/script/ml1.php?data=$data[0],11,$data[1],,1000";
$link3="http://thecloudatburkert.com/script/ml1.php?data=$data[0],12,$data[1],,1000";


	$html ='
<table border="none" cellspacing="3" cellpadding="2">
	<tr>
		<td colspan="3">
		<a href="'.$link1.'">
		<img src="http://thecloudatburkert.com/script/ml_img.php?data='.$data[0].',10,'.$data[1].',,1000", height="500"></a>
		</td>
	</tr>

</table>
';

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');



$pdf->SetFont('helvetica', '',8);
$pdf->SetFillColor(225,225,225);
$pdf->SetLineWidth(1);
$pdf->SetDrawColor(100,100,100);
$pdf->Rect(25, 129, 163, 118, 'DF');


$pdf->SetFillColor(225,225,225);
$pdf-> SetDrawColor(255,255,255);
$pdf->SetLineWidth(2.5);

$pdf->Rect(26, 130, 160, 115, 'DF');



$txt = '
<table border="1" cellpadding="3">
<tr>
<td colspan="8"></td>
</tr>


<tr>
<td width="3%"></td>
	<td style="text-align:right; font-weight:bold"width="15%"> Customer Name: </td>
	<td style="text-align:left" width="20%"> GorTech</td>
	

	<td style="text-align:right; font-weight:bold" width="15%"> PO Reference: </td>
	<td style="text-align:left" width="12%"> 345831 </td>
	

	<td style="text-align:right; font-weight:bold" width="20%"> Date of Calibration: </td>
	<td style="text-align:left" width="15%"> '.$row['TimeStamp'].' </td>
	
</tr>
<tr>
	<td width="3%"></td>
	<td style="text-align:right; font-weight:bold"> Operator: </td>
	<td style="text-align:left"> '.$row['s1'].' </td>
	
	</tr>
<tr>
	
<td width="3%"></td>
	<td style="text-align:right; font-weight:bold"> Production ID: </td>
	<td style="text-align:left"> '.$row['r5'].' </td>
	
</tr>
<tr>
	
	<td width="3%"></td>

	<td style="text-align:right; font-weight:bold"> Device ID: </td>
	<td style="text-align:left"> '.$row['r2'].' </td>
	
	
</tr>
<tr>
	<td width="3%"></td>

	<td style="text-align:right; font-weight:bold"> Serial: </td>
	<td style="text-align:left" width="15%"> '.$row['r4'].' </td>
	
</tr>

<tr>
	<td width="3%"></td>
	<td></td>
	<td style="font-weight:bold; text-align:center" colspan="4"> Calibration Results</td>
	
</tr>	
<tr>
	<td width="3%"></td>
	<td style="text-align:right; font-weight:bold">Full Scale :</td>
	<td style="text-align:left" width="15%"> '.$row['r8'].' l/m </td>
	<td style="text-align:left; font-weight:bold">Full Scale Eror: </td>
	<td style="text-align:left" width="15%"> '.$row['r10'].' % </td>
	<td style="text-align:left"> ( +/- '.($row['r8']/100)*$row['r10'].' l ) </td>
</tr>
<tr>
	<td width="3%"></td>
	<td style="text-align:right; font-weight:bold">Read Error: </td>
	<td style="text-align:left" width="15%"> '.$row['r11'].' % </td>

</tr>

<tr>
	<td width="3%"></td>
	<td style="text-align:right; font-weight:bold">K Factor: </td>
	<td style="text-align:left" width="15%"> '.$row['r9'].' ppl </td>
</tr>
<tr>
	<td width="3%"></td>
	<td style="text-align:right; font-weight:bold">Test Volume : </td>
	<td style="text-align:left" width="15%"> '.$Cal_volume.' L </td>
	<td style="text-align:right; font-weight:bold">Device Volume : </td>
	<td style="text-align:left" width="15%"> '.$Dev_volume.' L </td>
	<td style="text-align:right; font-weight:bold">Accuracy : </td>
	<td style="text-align:left" width="15%"> '.(number_format( (float) (($Dev_volume/$Cal_volume)*100), 2, '.', '')).' % </td>
</tr>

<tr>
	<td colspan="7"> </td>
</tr>
<tr>
<td width="3%"></td>
	<td colspan="6" style="text-align:left">Burkert Fluid Control Systems Certifies that the above mentioned instruments have been calibrated and are traceable to the National Insitute of Standards and Technology (NIST).
	Technician who performed your calibration: </td>
</tr>
<tr>
	<td colspan="7"> </td>
</tr>
<tr>
	<td colspan="7"> </td>
</tr>
<tr>
	<td colspan="7"> </td>
</tr>
<tr>
	<td colspan="7" style="text-align:center">X________________________________ </td>
</tr>

<tr>
	<td colspan="7"> </td>
</tr>
<tr>
	<td colspan="7" style="text-align:center"><B>IT IS POSSIBLE THAT SOME DEVICE OUTPUT SETTINGS MAY HAVE BEEN MODIFIED TO IMPROVE ACCURACY, PLEASE VERIFY ALL DEVICES SETTINGS INCLUDING ANALOG SCALE AND PULSE VOLUME BEFORE PLACING THE UNIT BACK IN SERVICE </B></td>
</tr>

</table>';




$pdf->SetFillColor(255,255,255);
$pdf->SetAlpha(1);

$pdf->writeHTMLCell(160,115, 26,129, $txt, 1, 1, true, 'J', true);

$pdf->lastPage();

$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);

	$html ='
<table border="none" cellspacing="1" cellpadding="1">
	
	<tr>
		<td colspan="5">
		<a href="'.$link2.'">
		<img src="http://thecloudatburkert.com/script/ml_img.php?data='.$data[0].',11,'.$data[1].',,1000", height="500"></a>
		</td>
	</tr><tr>
		<td colspan="5">
		<a href="'.$link2.'">
		<img src="http://thecloudatburkert.com/script/ml_img.php?data='.$data[0].',12,'.$data[1].',,1000", height="500"></a>
		</td>
	</tr>
</table>
';


$pdf->writeHTML($html, true, false, true, false, '');

//$pdf->lastPage();





// reset pointer to the last page
$pdf->lastPage();


$pdf->AddPage();

$pdf->setJPEGQuality(75);

$html = ' 
<h2> Test Report of Electromagnetic Flow Meter</h2>
<br>

<table border="none" cellpadding="2" cellspacing="0">

<tr>
<td style="font-weight:bold; text-align:right"> Report No: </td>
<td style="font-weight:bold; text-align:left"> LSTA03905S</td>

<td style="font-weight:bold; text-align:right">Print Date: </td>
<td style="font-weight:bold; text-align:left">  02/07/2015</td>
</tr>
<tr><td colspan="4"></td></tr>
				<tr>
					 <th style="font-weight:bold; text-align:center" colspan="2">SENSOR DATA </th>
					 <th style="font-weight:bold; text-align:center" colspan="2">CALIBRATION DATA </th>
								   
				</tr>
				<tr><td colspan="4"></td></tr>
<tr>
<td style="font-weight:bold;text-align:right"> Sensor Model: </td>
<td>SO 56-T25-3E1A</td>
<td style="font-weight:bold;text-align:right"> Converter Model: </td>
<td> SE 56-B1A1B1A0 </td>
</tr>
<tr>
<td style="font-weight:bold;text-align:right">Serial Number:</td>
<td> 09S2120</td>
<td style="font-weight:bold;text-align:right"> Serial Number: </td>
<td>31S005792</td>
</tr>
<tr>
<td style="font-weight:bold;text-align:right">Nominal Diameter:</td>
<td> 25</td>
</tr><tr>
<td style="font-weight:bold;text-align:right">Full Scale: </td>
<td> 5sm3/s</td>
</tr><tr>
<td style="font-weight:bold;text-align:right"> Coefficient KA:</td>
<td> -3.1462</td>
</tr><tr>
<td style="font-weight:bold;text-align:right"> Coefficient Kz: </td>
<td>-212</td>
</tr>
</table>








';
$pdf->writeHTML($html, true, false, true, false, '');
$pdf->lastPage();
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Print a table

// add a page
//$pdf->AddPage();

// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output('Calibration_'.$id.'.pdf', 'I');
?>